import { UserDTO } from "../DTO/user.js";
import models from "../models/index.js";

const attachCurrentUser = async (req, _res, next) => {
  try {
    const userUid = req.user.uid;

    const user = await models.user
      .findOne({ uid: userUid })
      .select({
        _id: 1,
        name: 1,
        uid: 1,
        email: 1,
        role: 1,
        createdAt: 1,
        updatedAt: 1,
      })
      .lean()
      .exec();

    if (!user) {
      const err = new Error("User not found!");
      err.statusCode = 401;
      throw err;
    }

    const userDTO = new UserDTO()
      .setId(user?._id)
      .setName(user?.name)
      .setUid(user?.uid)
      .setEmail(user?.email)
      .setRole(user?.role)
      .setCreatedAt(user?.createdAt)
      .setUpdatedAt(user?.updatedAt)
      .build();

    req.currentUser = userDTO;

    next();
  } catch (err) {
    next(err);
  }
};

export default attachCurrentUser;
